package app.firezone.synk.network.Activities;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import android.app.ProgressDialog;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.Toast;

import com.google.android.gms.auth.api.signin.GoogleSignIn;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInClient;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.tasks.Task;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GoogleAuthProvider;

import java.util.ArrayList;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.MainActivity;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ActivityLoginBinding;
import app.firezone.synk.network.model.AppModel;
import app.firezone.synk.network.model.CheckEmailResponse;
import app.firezone.synk.network.model.LoginResponse;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class LoginActivity extends AppCompatActivity {

    ActivityLoginBinding binding;
    FirebaseAuth auth;
    FirebaseUser currentUser;
    GoogleSignInClient mGoogleSignInClient;
    ProgressDialog pd;
    MyApi myApi;
    int RC_SIGN_IN = 11;
    String client_id;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityLoginBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        auth = FirebaseAuth.getInstance();
        currentUser = auth.getCurrentUser();
        myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);


        pd = new ProgressDialog(this);
        pd.setTitle("Please Wait");
        pd.setMessage("Logging you in...");

        // Fetch client_id from Laravel API
        myApi.fetchAppSetting().enqueue(new Callback<ArrayList<AppModel>>() {
            @Override
            public void onResponse(Call<ArrayList<AppModel>> call, Response<ArrayList<AppModel>> response) {
                if (response.isSuccessful() && response.body() != null && !response.body().isEmpty()) {
                    client_id = response.body().get(0).getGooglekey();
                }
            }

            @Override
            public void onFailure(Call<ArrayList<AppModel>> call, Throwable t) {
                Toast.makeText(LoginActivity.this, "Failed to fetch app settings", Toast.LENGTH_SHORT).show();
            }
        });

        // Auto login
        if (SharedPrefManager.getInstance(this).getUserId() != -1) {
            navigateToMainActivity();
            return;
        }

        // Google sign-in setup
        GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN)
                .requestIdToken(getString(R.string.client_id))
                .requestEmail()
                .build();

        mGoogleSignInClient = GoogleSignIn.getClient(this, gso);

        binding.btnSignIn.setOnClickListener(v -> {
            String email = binding.userEmail.getText().toString().trim();
            String password = binding.password.getText().toString();

            if (TextUtils.isEmpty(email)) {
                binding.userEmail.setError("Email is required");
                return;
            }

            if (TextUtils.isEmpty(password)) {
                binding.password.setError("Password is required");
                return;
            }

            pd.show();
            checkEmailExistandLoginVia(email, password);
        });

        binding.googleBtn.setOnClickListener(v -> initiateGoogleLogin());

        binding.noAccount.setOnClickListener(v ->
                startActivity(new Intent(LoginActivity.this, SignupActivity.class)));

        binding.forgetPassword.setOnClickListener(v ->
                startActivity(new Intent(LoginActivity.this, PassForgetActivity.class)));
    }

    private void checkEmailExistandLoginVia(String email, String password) {
        myApi.checkEmailExists(email).enqueue(new Callback<CheckEmailResponse>() {
            @Override
            public void onResponse(Call<CheckEmailResponse> call, Response<CheckEmailResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (response.body().isSuccess()) {
                        if (response.body().getLoginVia() == 0) {
                            login(email, password);
                        } else {
                            pd.dismiss();
                            Toast.makeText(LoginActivity.this, "Use Google Sign-In for this account", Toast.LENGTH_SHORT).show();
                        }
                    } else {
                        pd.dismiss();
                        Toast.makeText(LoginActivity.this, response.body().getMessage(), Toast.LENGTH_SHORT).show();
                    }
                } else {
                    pd.dismiss();
                    Toast.makeText(LoginActivity.this, "Authenticated....", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<CheckEmailResponse> call, Throwable t) {
                pd.dismiss();
                Toast.makeText(LoginActivity.this, "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    private void login(String email, String password) {
        myApi.loginUser(email, password).enqueue(new Callback<LoginResponse>() {
            @Override
            public void onResponse(Call<LoginResponse> call, Response<LoginResponse> response) {
                pd.dismiss();

                if (response.isSuccessful() && response.body() != null) {
                    LoginResponse res = response.body();

                    // Save tokens and userId
                    SharedPrefManager.getInstance(LoginActivity.this).saveUserId(res.getUserId());
                    SharedPrefManager.getInstance(LoginActivity.this).saveAccessToken(res.getAccess_token());

                    Toast.makeText(LoginActivity.this, "Login Successful", Toast.LENGTH_SHORT).show();
                    navigateToMainActivity();
                } else {
                    Toast.makeText(LoginActivity.this, "Invalid credentials", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<LoginResponse> call, Throwable t) {
                pd.dismiss();
                Toast.makeText(LoginActivity.this, "Login failed: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    private void initiateGoogleLogin() {
        startActivityForResult(mGoogleSignInClient.getSignInIntent(), RC_SIGN_IN);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        if (requestCode == RC_SIGN_IN) {
            Task<GoogleSignInAccount> task = GoogleSignIn.getSignedInAccountFromIntent(data);
            try {
                GoogleSignInAccount account = task.getResult(ApiException.class);
                if (account != null) {
                    checkGoogleExistLoginVia(account.getEmail(), account.getIdToken());
                }
            } catch (ApiException e) {
                Toast.makeText(this, "Google sign-in failed", Toast.LENGTH_SHORT).show();
            }
        }
    }

    private void checkGoogleExistLoginVia(String email, String idToken) {
        myApi.checkEmailExists(email).enqueue(new Callback<CheckEmailResponse>() {
            @Override
            public void onResponse(Call<CheckEmailResponse> call, Response<CheckEmailResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (response.body().isSuccess()) {
                        if (response.body().getLoginVia() == 1) {
                            authWithGoogle(idToken, email);
                        } else {
                            Toast.makeText(LoginActivity.this, "Use email & password for this account", Toast.LENGTH_SHORT).show();
                            pd.dismiss();
                        }
                    } else {
                        Toast.makeText(LoginActivity.this, response.body().getMessage(), Toast.LENGTH_SHORT).show();
                        pd.dismiss();
                    }
                }
            }

            @Override
            public void onFailure(Call<CheckEmailResponse> call, Throwable t) {
                pd.dismiss();
                Toast.makeText(LoginActivity.this, "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    private void authWithGoogle(String idToken, String email) {
        AuthCredential credential = GoogleAuthProvider.getCredential(idToken, null);
        auth.signInWithCredential(credential).addOnCompleteListener(task -> {
            if (task.isSuccessful()) {
                String password = auth.getUid(); // use UID as password
                login(email, password);
            } else {
                Toast.makeText(LoginActivity.this, "Google Auth failed", Toast.LENGTH_SHORT).show();
            }
        });
    }

    private void navigateToMainActivity() {
        Intent intent = new Intent(this, MainActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_NEW_TASK);
        startActivity(intent);
        finish();
    }
}
